/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverSettings;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6910;

public abstract class AbstractCarver {
    protected final CarverSettings settings;
    private final ImmutableSet<class_2680> DEBUG_BLOCKS = ImmutableSet.of((Object)class_2246.field_10205.method_9564(), (Object)class_2246.field_10161.method_9564(), (Object)class_2246.field_10445.method_9564(), (Object)class_2246.field_10002.method_9564(), (Object)class_2246.field_10234.method_9564(), (Object)class_2246.field_10104.method_9564(), (Object[])new class_2680[0]);

    public abstract int getSpawnWeight();

    public abstract int getBottomY();

    public abstract int getTopY();

    public abstract NoiseGen getNoiseGen();

    public AbstractCarver(CarverSettings settings) {
        this.settings = settings;
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, class_2791 chunkAccess, class_2338 blockPos, class_2680 airBlockState, class_2680 liquidBlockState, class_6643 carvingMask, class_6350 aquifer) {
        carvingMask.method_38865(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        if (!chunkAccess.method_8320(blockPos).method_40143(config.misc.replaceable())) {
            return;
        }
        if (airBlockState.method_26215() && blockPos.method_10264() <= this.settings.getLiquidAltitude()) {
            if (liquidBlockState != null) {
                chunkAccess.method_12010(blockPos, liquidBlockState, false);
            }
        } else {
            class_2680 newBlockState = aquifer.method_38317((class_6910.class_6912)new class_6910.class_6914(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), 0.0);
            if (newBlockState == null) {
                return;
            }
            chunkAccess.method_12010(blockPos, newBlockState, false);
            if (aquifer.method_33742() && !newBlockState.method_26227().method_15769()) {
                chunkAccess.method_12039(blockPos);
            }
        }
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, class_2791 chunkAccess, class_2338 blockPos, class_2680 liquidBlockState, class_6643 carvingMask, class_6350 aquifer) {
        this.carveBlock(config, chunkAccess, blockPos, class_2246.field_10124.method_9564(), liquidBlockState, carvingMask, aquifer);
    }

    protected void debugCarveBlock(class_2791 chunkIn, class_2338 blockPos, boolean digBlock) {
        if (this.DEBUG_BLOCKS.contains((Object)chunkIn.method_8320(blockPos))) {
            return;
        }
        if (digBlock) {
            chunkIn.method_12010(blockPos, this.settings.getDebugBlock(), false);
        } else {
            chunkIn.method_12010(blockPos, class_2246.field_10124.method_9564(), false);
        }
    }
}

